<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Post\Like;

trait TraitPostLikeSetters
{
    use TraitPostLikeProperties;

    /**
     * @return static 
     */
    final public function setId(string $id)
    {
        $this -> id = $id;

        return $this;
    }

    /**
     * @return static 
     */
    public function setLikedPostId(string $likedPostId)
    {
        $this -> likedPostId = $likedPostId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setLikedByUserId(string $likedByUserId)
    {
        $this -> likedByUserId = $likedByUserId;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampRegistration(string $stampRegistration)
    {
        $this -> stampRegistration = $stampRegistration;

        return $this;
    }

    /**
     * @return static 
     */
    public function setStampLastUpdate(string $stampLastUpdate)
    {
        $this -> stampLastUpdate = $stampLastUpdate;

        return $this;
    }
}
